// Generated by CoffeeScript 1.7.1
(function() {
  var EventEmitter, app, bindings;

  EventEmitter = require('events').EventEmitter;

  bindings = process.atomBinding('app');

  app = bindings.app;

  app.__proto__ = EventEmitter.prototype;

  app.getHomeDir = function() {
    return process.env[process.platform === 'win32' ? 'USERPROFILE' : 'HOME'];
  };

  app.setApplicationMenu = function(menu) {
    return require('menu').setApplicationMenu(menu);
  };

  app.getApplicationMenu = function() {
    return require('menu').getApplicationMenu();
  };

  app.commandLine = {
    appendSwitch: bindings.appendSwitch,
    appendArgument: bindings.appendArgument
  };

  if (process.platform === 'darwin') {
    app.dock = {
      bounce: function(type) {
        if (type == null) {
          type = 'informational';
        }
        return bindings.dockBounce(type);
      },
      cancelBounce: bindings.dockCancelBounce,
      setBadge: bindings.dockSetBadgeText,
      getBadge: bindings.dockGetBadgeText,
      hide: bindings.dockHide,
      show: bindings.dockShow
    };
  }

  app.once('ready', function() {
    return app.emit('finish-launching');
  });

  app.terminate = app.quit;

  app.exit = process.exit;

  module.exports = app;

}).call(this);
